<?php
class Auth {
    public function isAdminLoggedIn() {
        if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
            return false;
        }
        
        // Check session timeout (30 minutes)
        if (time() - $_SESSION['login_time'] > 1800) {
            $this->logout();
            return false;
        }
        
        // Update login time for active session
        $_SESSION['login_time'] = time();
        
        return true;
    }
    
    public function logout() {
        $_SESSION = array();
        
        if (ini_get("session.use_cookies")) {
            $params = session_get_cookie_params();
            setcookie(session_name(), '', time() - 42000,
                $params["path"], $params["domain"],
                $params["secure"], $params["httponly"]
            );
        }
        
        session_destroy();
    }
    
    public function requireAdmin() {
        if (!$this->isAdminLoggedIn()) {
            header('Location: login.php');
            exit;
        }
    }
    
    public function requireRole($requiredRole) {
        $this->requireAdmin();
        
        if ($_SESSION['admin_role'] !== $requiredRole && $_SESSION['admin_role'] !== 'super_admin') {
            header('HTTP/1.0 403 Forbidden');
            die('Access denied. Insufficient privileges.');
        }
    }
}



?>